
import java.awt.image.*;
// classe dei kernel di vari filtri
public class Kernels
{
    public Kernel kSobelX()  // KERNEL SobelX
      {
        float [] kernel =new float [9];

        kernel[0]=-1;  kernel[1]=-2;  kernel[2]=-1;
        kernel[3]=0;   kernel[4]=0;   kernel[5]=0;
        kernel[6]=1;   kernel[7]=2;   kernel[8]=1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
      }

   public Kernel kSobelY()  // KERNEL SobelY
      {
        float [] kernel =new float [9];

        kernel[0]=1; kernel[1]=0; kernel[2]=-1;
        kernel[3]=2; kernel[4]=0; kernel[5]=-2;
        kernel[6]=1; kernel[7]=0; kernel[8]=-1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
      }

   public Kernel kPrewittX() // kernel PrewittX
     {
        float [] kernel =new float [9];

        kernel[0]=-1;  kernel[1]=-1;  kernel[2]=-1;
        kernel[3]=0;   kernel[4]=0;   kernel[5]=0;
        kernel[6]=1;   kernel[7]=1;   kernel[8]=1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
    }

  public Kernel kPrewittY()  // KERNEL SobelY
      {
        float [] kernel =new float [9];

        kernel[0]=1; kernel[1]=0; kernel[2]=-1;
        kernel[3]=1; kernel[4]=0; kernel[5]=-1;
        kernel[6]=1; kernel[7]=0; kernel[8]=-1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
      }

  public Kernel kLaplaceX() // kernel LaplaceX
     {
        float [] kernel =new float [9];

        kernel[0]=-1;  kernel[1]=-0;  kernel[2]=-1;
        kernel[3]=0;   kernel[4]=4;   kernel[5]=0;
        kernel[6]=-1;   kernel[7]=0;   kernel[8]=-1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
    }
  
  public Kernel kLaplaceY()  // KERNEL LaplaceY
      {
        float [] kernel =new float [9];

        kernel[0]=-1; kernel[1]=0; kernel[2]=-1;
        kernel[3]=0; kernel[4]=4; kernel[5]=-0;
        kernel[6]=-1; kernel[7]=0; kernel[8]=-1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
      }

 public Kernel kSharpening() // kernel di sharpening
     {
        float [] kernel =new float [9];

        kernel[0]=-1;  kernel[1]=-0;  kernel[2]=-1;
        kernel[3]=0;   kernel[4]=5;   kernel[5]=0;
        kernel[6]=-1;   kernel[7]=0;   kernel[8]=-1;

        Kernel K=new Kernel(3,3,kernel);
        return K;
    }

 public Kernel kNBox(int n) // kernel di NBox
    {
      float [] kernel = new float[(n)*(n)];
       int i,j,k;
       for(i=0,k=0;i<n;i++)
          for(j=0;j<n;j++,k++) { 
                                kernel[k] = (1.0f / ((float)(n * n)) ); 
                                System.out.println(kernel[k]);

                                }
       
        Kernel K=new Kernel(n,n,kernel);
        return K;
    }


}
